/*
 * CGen2TagPowerReadMeasurement.h
 *
 *  Created on: 05.05.2011
 *      Author: stefan.detter
 */

#ifndef CGEN2TAGPOWERREADMEASUREMENT_H_
#define CGEN2TAGPOWERREADMEASUREMENT_H_

#include "../../../ui/TabWidget.h"
#include "../../../ui/ConfigDialog.h"
#include <ui_CGen2TagPowerReadMeasurement.h>

#include <QSet>
#include <qwt_matrix_raster_data.h>

class QrfeReaderInterface;
class QrfeTagInterface;
class QrfeGen2Tag;

namespace Ui{
	class CGen2TagEngineeringDialogClass;
}

class QStandardItemModel;
class QwtPlot;
class QwtPlotCurve;
class QwtPlotSpectrogram;
class QwtLinearColorMap;

class CGen2TagPowerReadMeasurement : public TagTabWidget, ConfigDialog
{
	Q_OBJECT

public:
	CGen2TagPowerReadMeasurement(QTextEdit* infoEdit, QWidget* parent);
	virtual ~CGen2TagPowerReadMeasurement();

	virtual bool init(QrfeReaderInterface* reader, QrfeTagInterface* tag);
	virtual void deinit();

	virtual bool hasExecutionCount();

private slots:
	void startButtonClicked();

	void runFrequencySweep();
	void clearValues();
	void sweepValuesChanged ( );

	void cyclicInventory(const QrfeGlobal::TagReadEvent& tag);

	void exportSweepResults();

private:
	void measurePowerVsReadCount(ulong freq, ushort att, int timeout, ushort& maxReadCount);

	QwtLinearColorMap* colorMap();

	void reloadLicenseData();

private:
	QrfeReaderInterface* 					m_reader;
	QrfeGen2Tag*							m_tag;
	QWidget* 								m_parent;

	QStandardItemModel*					m_freqSweepValueModel;
	QwtPlot*							m_freqSweepPlot;
	QwtPlotSpectrogram*					m_spectrogram;
	QwtMatrixRasterData*				m_data;

	bool								m_measurementActive;
	bool 								m_continueMeasurement;

	uint 								m_maxReadCount;
	QMap<QString, uint>					m_tagList;

    Ui::CGen2TagPowerReadMeasurement	ui;
};

#endif /* CGEN2TAGPOWERREADMEASUREMENT_H_ */
